/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.ChunkLoader;
import qouteall.imm_ptl.core.chunk_loading.DimensionalChunkPos;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTracking;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.LoadingIndicatorEntity;
import qouteall.imm_ptl.core.portal.PortalPlaceholderBlock;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.FastBlockAccess;
import qouteall.imm_ptl.core.portal.nether_portal.FrameSearching;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalMatcher;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class NetherPortalGeneration {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final LimitedLogger limitedLogger = new LimitedLogger(50);

    @Nullable
    public static IntBox findAirCubePlacement(class_3218 toWorld, class_2338 mappedPosInOtherDimension, class_2350.class_2351 axis, class_2338 neededAreaSize, boolean allowForcePlacement) {
        IntBox foundAirCube;
        class_2338 randomShift = new class_2338(toWorld.method_8409().method_43056() ? 1 : -1, 0, toWorld.method_8409().method_43056() ? 1 : -1);
        IntBox intBox = foundAirCube = axis == class_2350.class_2351.field_11052 ? NetherPortalMatcher.findHorizontalPortalPlacement(neededAreaSize, (class_1936)toWorld, mappedPosInOtherDimension.method_10081((class_2382)randomShift)) : NetherPortalMatcher.findVerticalPortalPlacement(neededAreaSize, (class_1936)toWorld, mappedPosInOtherDimension.method_10081((class_2382)randomShift));
        if (foundAirCube == null) {
            LOGGER.info("Cannot find normal portal placement");
            foundAirCube = NetherPortalMatcher.findCubeAirAreaAtAnywhere(neededAreaSize, (class_1936)toWorld, mappedPosInOtherDimension, 32);
            if (foundAirCube != null && NetherPortalGeneration.isFloating(toWorld, foundAirCube)) {
                foundAirCube = NetherPortalMatcher.levitateBox((class_1936)toWorld, foundAirCube, 50);
            }
        }
        if (foundAirCube == null) {
            if (allowForcePlacement) {
                Helper.err("Cannot find air cube within 32 blocks? Force placed portal. It will occupy normal blocks.");
                return IntBox.fromBasePointAndSize(mappedPosInOtherDimension, neededAreaSize);
            }
            return null;
        }
        return foundAirCube;
    }

    private static boolean isFloating(class_3218 toWorld, IntBox foundAirCube) {
        return foundAirCube.getSurfaceLayer(class_2350.field_11033).stream().noneMatch(blockPos -> toWorld.method_8320(blockPos.method_10074()).method_51367());
    }

    public static void setPortalContentBlock(class_3218 world, class_2338 pos, class_2350.class_2351 normalAxis) {
        world.method_8501(pos, (class_2680)PortalPlaceholderBlock.instance.method_9564().method_11657(PortalPlaceholderBlock.AXIS, (Comparable)normalAxis));
    }

    public static void startGeneratingPortal(class_3218 fromWorld, class_3218 toWorld, BlockPortalShape fromShape, class_2338 toPos, int existingFrameSearchingRadius, Predicate<class_2680> otherSideFramePredicate, Consumer<BlockPortalShape> newFrameGenerateFunc, Consumer<PortalGenInfo> portalEntityGeneratingFunc, Supplier<PortalGenInfo> newFramePlacer, BooleanSupplier portalIntegrityChecker, FrameSearching.FrameSearchingFunc<PortalGenInfo> matchShapeByFramePos) {
        class_5321 fromDimension = fromWorld.method_27983();
        class_5321 toDimension = toWorld.method_27983();
        MinecraftServer server = fromWorld.method_8503();
        class_243 indicatorPos = fromShape.innerAreaBox.getCenterVec();
        LoadingIndicatorEntity indicatorEntity = (LoadingIndicatorEntity)LoadingIndicatorEntity.entityType.method_5883((class_1937)fromWorld);
        indicatorEntity.isValid = true;
        indicatorEntity.method_5814(indicatorPos.field_1352, indicatorPos.field_1351, indicatorPos.field_1350);
        indicatorEntity.setBox(fromShape.innerAreaBox);
        fromWorld.method_8649((class_1297)indicatorEntity);
        Runnable onGenerateNewFrame = () -> {
            indicatorEntity.inform((class_2561)class_2561.method_43471((String)"imm_ptl.generating_new_frame"));
            PortalGenInfo info = (PortalGenInfo)newFramePlacer.get();
            if (info != null) {
                newFrameGenerateFunc.accept(info.toShape);
                portalEntityGeneratingFunc.accept(info);
                O_O.postPortalSpawnEventForge(info);
            }
        };
        boolean otherSideChunkAlreadyGenerated = McHelper.getDoesRegionFileExist((class_5321<class_1937>)toDimension, toPos);
        int frameSearchingRadius = Math.floorDiv(existingFrameSearchingRadius, 16) + 1;
        int loaderRadius = otherSideChunkAlreadyGenerated ? frameSearchingRadius : (fromShape.getShapeInnerLength() < 16 ? 1 : 2);
        ChunkLoader chunkLoader = new ChunkLoader(new DimensionalChunkPos((class_5321<class_1937>)toDimension, new class_1923(toPos)), loaderRadius);
        ImmPtlChunkTracking.addGlobalAdditionalChunkLoader(server, chunkLoader);
        Runnable finalizer = () -> {
            indicatorEntity.method_5650(class_1297.class_5529.field_26998);
            ImmPtlChunkTracking.removeGlobalAdditionalChunkLoader(server, chunkLoader);
        };
        ServerTaskList.of(server).addTask(() -> {
            int allChunksNeedsLoading;
            boolean isPortalIntact = portalIntegrityChecker.getAsBoolean();
            if (!isPortalIntact) {
                finalizer.run();
                return true;
            }
            int loadedChunks = chunkLoader.getLoadedChunkNum(server);
            if (loadedChunks < (allChunksNeedsLoading = chunkLoader.getChunkNum())) {
                indicatorEntity.inform((class_2561)class_2561.method_43469((String)"imm_ptl.loading_chunks", (Object[])new Object[]{loadedChunks, allChunksNeedsLoading}));
                return false;
            }
            if (!otherSideChunkAlreadyGenerated) {
                onGenerateNewFrame.run();
                finalizer.run();
                return true;
            }
            ChunkLoader chunkLoader1 = new ChunkLoader(chunkLoader.getCenter(), frameSearchingRadius);
            class_3218 world = McHelper.getServerWorld(server, chunkLoader1.dimension());
            FastBlockAccess chunkRegion = chunkLoader1.createFastBlockAccess(world);
            indicatorEntity.inform((class_2561)class_2561.method_43471((String)"imm_ptl.searching_for_frame"));
            FrameSearching.startSearchingPortalFrameAsync(chunkRegion, frameSearchingRadius, toPos, otherSideFramePredicate, matchShapeByFramePos, info -> {
                portalEntityGeneratingFunc.accept((PortalGenInfo)info);
                finalizer.run();
                O_O.postPortalSpawnEventForge(info);
            }, () -> {
                onGenerateNewFrame.run();
                finalizer.run();
            });
            return true;
        });
    }

    public static boolean isOtherGenerationRunning(class_3218 fromWorld, class_243 indicatorPos) {
        boolean isOtherGenerationRunning = McHelper.getEntitiesNearby((class_1937)fromWorld, indicatorPos, LoadingIndicatorEntity.class, 1.0).stream().findAny().isPresent();
        if (isOtherGenerationRunning) {
            Helper.log("Aborted Portal Generation Because Another Generation is Running Nearby");
            return true;
        }
        return false;
    }

    public static boolean checkPortalGeneration(class_3218 fromWorld, class_2338 startingPos) {
        if (!fromWorld.method_22340(startingPos)) {
            Helper.log("Cancel Portal Generation Because Chunk Not Loaded");
            return false;
        }
        limitedLogger.log(String.format("Portal Generation Attempted %s %s %s %s", fromWorld.method_27983().method_29177(), startingPos.method_10263(), startingPos.method_10264(), startingPos.method_10260()));
        return true;
    }

    public static BlockPortalShape findFrameShape(class_3218 fromWorld, class_2338 startingPos, Predicate<class_2680> thisSideAreaPredicate, Predicate<class_2680> thisSideFramePredicate) {
        return Arrays.stream(class_2350.class_2351.values()).map(axis -> BlockPortalShape.findShapeWithoutRegardingStartingPos(startingPos, axis, pos -> thisSideAreaPredicate.test(fromWorld.method_8320(pos)), pos -> thisSideFramePredicate.test(fromWorld.method_8320(pos)))).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static void embodyNewFrame(class_3218 toWorld, BlockPortalShape toShape, class_2680 frameBlockState) {
        toShape.frameAreaWithCorner.forEach(blockPos -> toWorld.method_8501(blockPos, frameBlockState));
    }

    public static void fillInPlaceHolderBlocks(class_3218 world, BlockPortalShape blockPortalShape) {
        blockPortalShape.area.forEach(blockPos -> NetherPortalGeneration.setPortalContentBlock(world, blockPos, blockPortalShape.axis));
    }
}

